Ext.data.JsonP.sol_common_ExecUtils({"tagname":"class","name":"sol.common.ExecUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.ExecUtils.js","href":"lib_sol.common.ExecUtils.html#sol-common-ExecUtils"}],"eloas":true,"eloix":true,"elojc":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getJavaMainVersionNumber","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getJavaMainVersionNumber","meta":{}},{"name":"getJavaTimeZoneOffsetString","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getJavaTimeZoneOffsetString","meta":{}},{"name":"getJavaTimeZoneString","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getJavaTimeZoneString","meta":{}},{"name":"getJavaVersion","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getJavaVersion","meta":{}},{"name":"getProgramFilesDir","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getProgramFilesDir","meta":{}},{"name":"getProgramFilesX86Dir","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getProgramFilesX86Dir","meta":{}},{"name":"getTimeZoneOffsetString","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getTimeZoneOffsetString","meta":{}},{"name":"getUserProfileDir","tagname":"method","owner":"sol.common.ExecUtils","id":"method-getUserProfileDir","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"insideTomcat","tagname":"method","owner":"sol.common.ExecUtils","id":"method-insideTomcat","meta":{}},{"name":"logSystemInfo","tagname":"method","owner":"sol.common.ExecUtils","id":"method-logSystemInfo","meta":{}},{"name":"open","tagname":"method","owner":"sol.common.ExecUtils","id":"method-open","meta":{}},{"name":"runBatchFileInWindow","tagname":"method","owner":"sol.common.ExecUtils","id":"method-runBatchFileInWindow","meta":{}},{"name":"startProcess","tagname":"method","owner":"sol.common.ExecUtils","id":"method-startProcess","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ExecUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ExecUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils' target='_blank'>lib_sol.common.ExecUtils.js</a></div></pre><div class='doc-contents'><p>Execution utils</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getJavaMainVersionNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getJavaMainVersionNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getJavaMainVersionNumber' class='name expandable'>getJavaMainVersionNumber</a>( <span class='pre'></span> ) : Integer<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Java main version number ...</div><div class='long'><p>Returns the Java main version number</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Integer</span><div class='sub-desc'><p>Java main version number</p>\n</div></li></ul></div></div></div><div id='method-getJavaTimeZoneOffsetString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getJavaTimeZoneOffsetString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getJavaTimeZoneOffsetString' class='name expandable'>getJavaTimeZoneOffsetString</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Java time zone offset string ...</div><div class='long'><p>Returns the Java time zone offset string</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Java time zone offset string</p>\n</div></li></ul></div></div></div><div id='method-getJavaTimeZoneString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getJavaTimeZoneString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getJavaTimeZoneString' class='name expandable'>getJavaTimeZoneString</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Java time zone string ...</div><div class='long'><p>Returns the Java time zone string</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Java time zone string</p>\n</div></li></ul></div></div></div><div id='method-getJavaVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getJavaVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getJavaVersion' class='name expandable'>getJavaVersion</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Java version ...</div><div class='long'><p>Returns the Java version</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Java version</p>\n</div></li></ul></div></div></div><div id='method-getProgramFilesDir' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getProgramFilesDir' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getProgramFilesDir' class='name expandable'>getProgramFilesDir</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the program files directory ...</div><div class='long'><p>Returns the program files directory</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Path of the program files directory</p>\n</div></li></ul></div></div></div><div id='method-getProgramFilesX86Dir' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getProgramFilesX86Dir' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getProgramFilesX86Dir' class='name expandable'>getProgramFilesX86Dir</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Program files directory ...</div><div class='long'><p>Returns the Program files directory</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Path of the Program files directory</p>\n</div></li></ul></div></div></div><div id='method-getTimeZoneOffsetString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getTimeZoneOffsetString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getTimeZoneOffsetString' class='name expandable'>getTimeZoneOffsetString</a>( <span class='pre'>timeZoneString</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the time zone offset string from a given time zone string ...</div><div class='long'><p>Returns the time zone offset string from a given time zone string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>timeZoneString</span> : String<div class='sub-desc'><p>Time zone string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Time zone offset string</p>\n</div></li></ul></div></div></div><div id='method-getUserProfileDir' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-getUserProfileDir' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-getUserProfileDir' class='name expandable'>getUserProfileDir</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the user profile directory ...</div><div class='long'><p>Returns the user profile directory</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Path of the user profile directory</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-insideTomcat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-insideTomcat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-insideTomcat' class='name expandable'>insideTomcat</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Detects if the script runs inside Tomcat ...</div><div class='long'><p>Detects if the script runs inside Tomcat</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-logSystemInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-logSystemInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-logSystemInfo' class='name expandable'>logSystemInfo</a>( <span class='pre'>conn</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs system info ...</div><div class='long'><p>Logs system info</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>conn</span> : de.elo.ix.client.IXConnection<div class='sub-desc'><p>IXConnection</p>\n</div></li></ul></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-open' class='name expandable'>open</a>( <span class='pre'>path</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a file by \"ShellExecute\" ...</div><div class='long'><p>Opens a file by \"ShellExecute\"</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-runBatchFileInWindow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-runBatchFileInWindow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-runBatchFileInWindow' class='name expandable'>runBatchFileInWindow</a>( <span class='pre'>args, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Runs a batch file in a command window ...</div><div class='long'><p>Runs a batch file in a command window</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : Array<div class='sub-desc'><p>Arguments. The first element must be the batch file name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>dir</span> : String<div class='sub-desc'><p>Directory</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-startProcess' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ExecUtils'>sol.common.ExecUtils</span><br/><a href='source/lib_sol.common.ExecUtils.html#sol-common-ExecUtils-method-startProcess' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ExecUtils-method-startProcess' class='name expandable'>startProcess</a>( <span class='pre'>args, config</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts a process ...</div><div class='long'><p>Starts a process</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : Array<div class='sub-desc'><p>Arguments</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Config</p>\n<ul><li><span class='pre'>dir</span> : String<div class='sub-desc'><p>Directory</p>\n</div></li><li><span class='pre'>wait</span> : Boolean<div class='sub-desc'><p>Wait</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Result</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});